#include "AgentFactory.h"

using namespace std;

namespace Communication
{

AgentFactory* AgentFactory::instance = 0;


AgentFactory::AgentFactory()
{
}

AgentFactory* AgentFactory::GetInstance()
{
	if (instance==0)
		instance =  new AgentFactory();
	return instance;
}


IAgent* AgentFactory::GetAgent(DataAgent *data)
{
	IAgent *agent=0;
	if (DataGUIAgent *datagui = dynamic_cast<DataGUIAgent *>(data))
	{
		agent = new GUIAgent(datagui->GetPort(), datagui->GetIP(), datagui->GetSyncMode(),datagui->GetBroadcastInterval(),datagui->GetKey());	
	}
	else if (DataRobotControllerAgent *datarobot = dynamic_cast<DataRobotControllerAgent *>(data))
	{
		agent = new RobotControllerAgent(datarobot->GetPort(), datarobot->GetIP(), datarobot->GetSyncMode(),datarobot->GetBroadcastInterval(), datarobot->GetRobotIds(),datarobot->GetKey());
	}
	return agent;
	
}

}
